/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.editor.scanner;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.core.PHPVersionProvider;
import com.aptana.editor.php.internal.parser.PHPTokenType;
import com.aptana.editor.php.internal.ui.editor.scanner.IPHPTokenScanner;
import com.aptana.editor.php.internal.ui.editor.scanner.PHPTokenScanner;
import com.aptana.editor.php.internal.ui.editor.scanner.QueuedToken;
import com.aptana.editor.php.internal.ui.editor.scanner.tokenMap.IPHPTokenMapper;
import com.aptana.editor.php.internal.ui.editor.scanner.tokenMap.PHPTokenMapperFactory;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java_cup.runtime.Symbol;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;

public class PHPCodeScanner
implements ITokenScanner {
    private final IPHPTokenScanner fScanner = new PHPTokenScanner(PHPVersionProvider.getPHPVersion(null));
    private Queue<QueuedToken> queue;
    private int fLength;
    private int fOffset;
    private IDocument document;
    private int originalDocumentOffset;
    private IToken lastToken;
    private boolean inFunctionDeclaration;

    public int getTokenLength() {
        return this.fLength;
    }

    public int getTokenOffset() {
        return this.fOffset;
    }

    public IToken nextToken() {
        IToken token = this.pop();
        if (token.isEOF()) {
            return Token.EOF;
        }
        IPHPTokenMapper tokenMapper = PHPTokenMapperFactory.getMapper(this.fScanner.getPHPVersion());
        token = tokenMapper.mapToken((Symbol)token.getData(), this);
        if (this.scopeEquals(token, PHPTokenType.STORAGE_TYPE_FUNCTION)) {
            this.inFunctionDeclaration = true;
        } else if (this.scopeEquals(this.lastToken, PHPTokenType.STORAGE_TYPE_FUNCTION) && (this.scopeEquals(token, "") || this.scopeEquals(token, PHPTokenType.CONSTANT_OTHER))) {
            token = this.getToken(PHPTokenType.ENTITY_FUNCTION.toString());
        } else if (this.scopeEquals(this.lastToken, PHPTokenType.STORAGE_TYPE_CLASS) && (this.scopeEquals(token, "") || this.scopeEquals(token, PHPTokenType.CONSTANT_OTHER))) {
            token = this.getToken(PHPTokenType.ENTITY_CLASS.toString());
        } else if (this.inFunctionDeclaration && this.scopeEquals(this.lastToken, PHPTokenType.PUNCTUATION_PARAM_RIGHT)) {
            this.inFunctionDeclaration = false;
        } else if (!this.inFunctionDeclaration && (this.scopeEquals(token, PHPTokenType.PUNCTUATION_PARAM_LEFT) || this.scopeEquals(token, PHPTokenType.PUNCTUATION_PARAM_RIGHT))) {
            token = this.getToken("");
        } else if (this.scopeEquals(this.lastToken, PHPTokenType.PUNCTUATION_LBRACKET) && this.scopeEquals(token, PHPTokenType.CONSTANT_NUMERIC)) {
            token = this.getToken("variable.other.php constant.numeric.php");
        } else if (this.scopeEquals(this.lastToken, PHPTokenType.KEYWORD_OP_CLASS) && (this.scopeEquals(token, "") || this.scopeEquals(token, PHPTokenType.CONSTANT_OTHER))) {
            IToken nextMapped;
            int lastOffset = this.getTokenOffset();
            int lastLength = this.getTokenLength();
            ArrayList<QueuedToken> popped = new ArrayList<QueuedToken>();
            IToken next = this.pop();
            while (next.isWhitespace()) {
                popped.add(new QueuedToken(next, this.getTokenOffset(), this.getTokenLength()));
                next = this.pop();
            }
            popped.add(new QueuedToken(next, this.getTokenOffset(), this.getTokenLength()));
            token = !next.isEOF() ? (this.scopeEquals(nextMapped = tokenMapper.mapToken((Symbol)next.getData(), this), PHPTokenType.PUNCTUATION_PARAM_LEFT) ? this.getToken(PHPTokenType.META_FUNCTION_CALL_OBJECT) : this.getToken(PHPTokenType.VARIABLE_OTHER_PROPERTY)) : this.getToken(PHPTokenType.VARIABLE_OTHER_PROPERTY);
            for (QueuedToken addBack : popped) {
                this.push(addBack.getToken(), addBack.getOffset(), addBack.getLength());
            }
            this.fLength = lastLength;
            this.fOffset = lastOffset;
        } else if (this.scopeEquals(token, PHPTokenType.CONSTANT_OTHER)) {
            IToken nextMapped;
            int lastOffset = this.getTokenOffset();
            int lastLength = this.getTokenLength();
            ArrayList<QueuedToken> popped = new ArrayList<QueuedToken>();
            IToken next = this.pop();
            while (next.isWhitespace()) {
                popped.add(new QueuedToken(next, this.getTokenOffset(), this.getTokenLength()));
                next = this.pop();
            }
            popped.add(new QueuedToken(next, this.getTokenOffset(), this.getTokenLength()));
            if (!next.isEOF() && this.scopeEquals(nextMapped = tokenMapper.mapToken((Symbol)next.getData(), this), PHPTokenType.PUNCTUATION_PARAM_LEFT)) {
                token = this.getToken(PHPTokenType.META_FUNCTION_CALL);
            }
            for (QueuedToken addBack : popped) {
                this.push(addBack.getToken(), addBack.getOffset(), addBack.getLength());
            }
            this.fLength = lastLength;
            this.fOffset = lastOffset;
        }
        if (token.isOther()) {
            this.lastToken = token;
        }
        if (this.inFunctionDeclaration) {
            return this.getToken("meta.function.php " + token.getData());
        }
        return token;
    }

    private boolean scopeEquals(IToken token, PHPTokenType type) {
        return this.scopeEquals(token, type.toString());
    }

    private boolean scopeEquals(IToken token, String scope) {
        return token != null && token.getData() != null && scope.equals(token.getData());
    }

    public void setRange(IDocument document, int offset, int length) {
        this.document = document;
        this.originalDocumentOffset = offset;
        this.fScanner.setRange(document, offset, length);
        this.reset();
    }

    public String getSymbolValue(Symbol sym) {
        try {
            String contents = this.fScanner.getContents();
            return contents.substring(sym.left, sym.right);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"PHP code-scanner - Error getting a symbol value", (Throwable)e);
            return null;
        }
    }

    public IToken getToken(PHPTokenType type) {
        return this.getToken(type.toString());
    }

    public IToken getToken(String tokenName) {
        return CommonUtil.getToken((String)tokenName);
    }

    public int peek() {
        int oldOffset = this.getTokenOffset();
        int oldLength = this.getTokenLength();
        IToken next = this.pop();
        this.push(next);
        this.fOffset = oldOffset;
        this.fLength = oldLength;
        if (next.isEOF()) {
            return -1;
        }
        Integer data = (Integer)next.getData();
        return data;
    }

    private IToken pop() {
        IToken token = null;
        if (this.queue == null || this.queue.isEmpty()) {
            token = this.fScanner.nextToken();
            this.fOffset = this.fScanner.getTokenOffset();
            this.fLength = this.fScanner.getTokenLength();
        } else {
            QueuedToken queued = this.queue.poll();
            this.fOffset = queued.getOffset();
            this.fLength = queued.getLength();
            token = queued.getToken();
        }
        if (token == null || token.isEOF()) {
            return Token.EOF;
        }
        return token;
    }

    private void push(IToken next) {
        this.push(next, this.getTokenOffset(), this.getTokenLength());
    }

    private void push(IToken next, int offset, int length) {
        if (this.queue == null) {
            this.queue = new LinkedList<QueuedToken>();
        }
        this.queue.add(new QueuedToken(next, offset, length));
    }

    private void reset() {
        this.queue = null;
        this.inFunctionDeclaration = false;
        this.lastToken = null;
    }
}

